function [residual, g1, g2, g3] = World_Economy_Cartel_cheaters_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations.
%                                          Dynare may prepend or append auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g3        [M_.endo_nbr by (M_.endo_nbr)^3] double   Third derivatives matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 76, 1);

%
% Model equations
%

T18 = exp(y(26))-params(9)*exp(y(25))^(1+params(8))/(1+params(8));
T21 = T18^(-params(15));
T33 = params(23)^(-1);
T36 = exp(y(29));
T70 = exp(y(1))*y(40)+T33*y(48)*(-(T36*exp(y(1))*exp(y(16))))+T33*y(51)*(-(exp(y(1))*T36))+T33*y(52)*(-(T36*exp(y(1))*exp(y(14)-y(31))))+T33*y(55)*(-(exp(y(1))*T36*exp((-y(31)))));
T84 = exp(y(2))/(exp(y(2))+exp(y(4)));
T91 = params(12)^(1-params(4));
T111 = params(14)^(1-params(4));
T137 = exp(y(4))/(exp(y(2))+exp(y(4)));
T142 = params(13)^(1-params(4));
T175 = exp(y(1))*exp(y(5))-exp(y(5))*params(6)*exp(y(38)-y(31))^(params(5)-1);
T181 = exp(y(5))/(exp(y(5))+exp(y(6)));
T196 = exp(y(6))/(exp(y(5))+exp(y(6)));
T247 = exp(y(8))*y(57)+params(23)*y(44)*exp(y(8))*params(6)*exp(params(5)*(y(15)-y(31)))+params(23)*y(57)*(-(exp(y(8))*(1-exp((-y(31)))*exp(y(15)))))+params(23)*y(63)*(-(exp(y(8))*exp((-y(31)))*exp(y(15))));
T270 = exp(y(9))*y(56)+params(23)*y(44)*exp(y(9))*params(6)*exp(y(16)*params(5))+params(23)*y(56)*(-(exp(y(9))*(1-exp(y(16)))))+params(23)*y(62)*(-(exp(y(16))*exp(y(9))));
T294 = params(23)*y(64)*(-(exp(y(10))*exp((-y(31)))*exp(y(14))));
T295 = exp(y(10))*y(58)+params(23)*y(44)*exp(y(10))*params(6)*exp((y(14)-y(31))*params(5))+params(23)*y(58)*(-(exp(y(10))*(1-exp((-y(31)))*exp(y(14)))))+T294;
T353 = (-(T36*(exp(y(1))*exp(y(14)-y(31))+y(21)*(-exp(y(14)-y(31)))-params(6)*params(5)*exp((y(14)-y(31))*params(5)))));
T354 = y(52)*T353;
T379 = params(23)*y(63)*(-(exp(y(8))*exp((-y(31)))*exp(y(15))))+params(23)*y(44)*exp(y(8))*params(6)*params(5)*exp(params(5)*(y(15)-y(31)))+params(23)*y(57)*(-(exp(y(8))*(-(exp((-y(31)))*exp(y(15))))));
T400 = (-(T36*(exp(y(1))*exp(y(16))+y(18)*(-exp(y(16)))-params(6)*params(5)*exp(y(16)*params(5)))));
T401 = y(48)*T400;
T450 = exp(y(23))^(1/params(2));
T452 = (-1)/params(2);
T454 = exp(y(20))*getPowerDeriv(exp(y(20)),T452,1);
T460 = (params(2)-1)/params(2);
T462 = exp(y(20))*getPowerDeriv(exp(y(20)),T460,1);
T472 = exp(y(24))^params(3);
T474 = exp(y(25))^(1-params(3));
T475 = T472*T474;
T476 = T475^T460;
T480 = (1-params(11))*exp(T460*y(30))*T476+params(11)*exp(y(20))^T460;
T482 = getPowerDeriv(T480,params(2)/(params(2)-1),1);
T516 = exp(y(24))^(params(3)-1);
T517 = T475^T452;
T521 = exp(y(23))*getPowerDeriv(exp(y(23)),1/params(2),1);
T530 = exp(y(25))^(-params(3));
T539 = exp(y(20))^T452;
T555 = exp(y(24))*getPowerDeriv(exp(y(24)),params(3),1);
T557 = getPowerDeriv(T475,T460,1);
T559 = (1-params(11))*exp(T460*y(30))*T474*T555*T557;
T564 = T450*exp(T460*y(30))*(1-params(11))*(1-params(3));
T567 = getPowerDeriv(T475,T452,1);
T568 = T474*T555*T567;
T571 = T555*T517*T564+T472*T564*T568;
T577 = T450*exp(T460*y(30))*(1-params(11))*params(3);
T582 = exp(y(24))*getPowerDeriv(exp(y(24)),params(3)-1,1);
T586 = (-(T474*(T516*T568*T577+T517*T577*T582)));
T612 = exp(y(25))*getPowerDeriv(exp(y(25)),1+params(8),1);
T615 = (-(params(9)*T612/(1+params(8))));
T616 = getPowerDeriv(T18,(-params(15)),1);
T617 = T615*T616;
T630 = (-(exp(T460*y(30))*exp(y(24)*params(3))*(1-params(3))*exp(y(25)*(1-params(3)))));
T634 = exp(y(25))*getPowerDeriv(exp(y(25)),1-params(3),1);
T649 = exp(y(25))*getPowerDeriv(exp(y(25)),(-params(3)),1);
T655 = (1-params(11))*exp(T460*y(30))*T557*T472*T634;
T703 = params(9)^((-1)/params(8));
T708 = exp(y(28))*getPowerDeriv(exp(y(28)),1/params(8),1);
T719 = T36*params(6)*params(5)*exp((y(14)-y(31))*(params(5)-1))-T36*exp((-y(31)))*(exp(y(1))-y(21));
T726 = T36*params(6)*params(5)*exp(y(16)*(params(5)-1))-T36*(exp(y(1))-y(18));
T741 = (-(T36*(exp(y(1))*exp(y(16))+(1-exp(y(16)))*y(18)-params(6)*exp(y(16)*params(5)))));
T755 = (-(T36*(exp(y(1))*exp(y(14)-y(31))+y(21)*(1-exp(y(14)-y(31)))-params(6)*exp((y(14)-y(31))*params(5)))));
T764 = T33*y(55)*T719+T33*y(51)*T726+T36*y(47)+T33*y(46)*(-(T36*(1+exp(y(27))-params(10))))+T33*y(48)*T741+T33*y(49)*(-(y(19)*T36*(1-params(7))))+T33*y(52)*T755+T33*y(53)*(-(y(22)*T36*(1-params(7))));
T791 = T476*(1-params(11))*T460*exp(T460*y(30));
T798 = params(23)^2;
T809 = getPowerDeriv(exp(y(38)-y(31)),params(5)-1,1);
T820 = y(64)*(-(exp(y(10))*exp(y(14))*(-exp((-y(31))))));
T824 = y(63)*(-(exp(y(8))*exp(y(15))*(-exp((-y(31))))));
T828 = y(58)*(-(exp(y(10))*(-(exp(y(14))*(-exp((-y(31))))))));
T832 = y(57)*(-(exp(y(8))*(-(exp(y(15))*(-exp((-y(31))))))));
T840 = exp(y(8))*params(6)*exp(params(5)*(y(15)-y(31)))*(-params(5))+exp(y(10))*params(6)*exp((y(14)-y(31))*params(5))*(-params(5));
T847 = (-(T36*(exp(y(1))*(-exp(y(14)-y(31)))+exp(y(14)-y(31))*y(21)-params(6)*exp((y(14)-y(31))*params(5))*(-params(5)))));
T849 = T33*y(52)*T847;
T857 = T36*params(6)*params(5)*exp((y(14)-y(31))*(params(5)-1))*(-(params(5)-1))-(exp(y(1))-y(21))*T36*(-exp((-y(31))));
T859 = T33*y(55)*T857;
residual(1) = T21*exp(y(1))*exp(y(5))+(-y(69))+T70+y(69)*params(23);
residual(2) = T21*(-exp(y(2)))+y(71)*(-T84)+y(60)*(-(T91*params(4)*exp(y(2)*params(4))))+exp(y(2))*y(44)+params(23)*y(71)*T84;
residual(3) = (-y(70))+y(59)*(-(T111*params(4)*exp(params(4)*y(3))))+y(50)*y(19)*T111*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1))+y(44)*exp(y(3))+params(23)*y(70);
residual(4) = y(71)*(-T137)+y(61)*(-(T142*params(4)*exp(y(4)*params(4))))+y(54)*y(22)*T142*params(4)*(params(4)-1)*exp(y(4)*(params(4)-1))+exp(y(4))*y(44)+params(23)*y(71)*T137;
residual(5) = T21*T175+y(73)*(-T181)+y(65)*(-exp(y(5)))+exp(y(5))*y(63)+params(23)*y(73)*T181;
residual(6) = y(73)*(-T196)+y(65)*(-exp(y(6)))+exp(y(6))*y(64)+params(23)*y(73)*T196;
residual(7) = (-y(72))+y(65)*(-exp(y(7)))+exp(y(7))*y(62)+params(23)*y(72);
residual(8) = T247;
residual(9) = T270;
residual(10) = T295;
residual(11) = y(60)*exp(y(11))+y(57)*(-(exp(y(11))*params(7)))+params(23)*y(60)*(-(exp(y(11))*(1-params(7))));
residual(12) = y(59)*exp(y(12))+y(56)*(-(params(7)*exp(y(12))))+params(23)*y(59)*(-((1-params(7))*exp(y(12))));
residual(13) = y(61)*exp(y(13))+y(58)*(-(params(7)*exp(y(13))))+params(23)*y(61)*(-((1-params(7))*exp(y(13))));
residual(14) = T294+y(55)*T36*params(6)*params(5)*(params(5)-1)*exp((y(14)-y(31))*(params(5)-1))+T354+params(23)*y(44)*exp(y(10))*params(6)*params(5)*exp((y(14)-y(31))*params(5))+params(23)*y(58)*(-(exp(y(10))*(-(exp((-y(31)))*exp(y(14))))));
residual(15) = T379+params(23)*y(68)*(-exp(y(15)));
residual(16) = params(23)*y(62)*(-(exp(y(16))*exp(y(9))))+y(51)*T36*params(6)*params(5)*(params(5)-1)*exp(y(16)*(params(5)-1))+T401+params(23)*y(44)*exp(y(9))*params(6)*params(5)*exp(y(16)*params(5))+params(23)*y(56)*(-(exp(y(9))*(-exp(y(16)))));
residual(17) = exp(y(17))*y(43);
residual(18) = y(49)*(-params(7))+y(48)+T33*y(48)*(-(T36*(1-exp(y(16)))))+T33*T36*y(51);
residual(19) = y(50)*T111*params(4)*exp(y(3)*(params(4)-1))+y(49)+T33*y(49)*(-(T36*(1-params(7))));
residual(20) = y(65)*exp(y(20))+y(40)*(-(params(11)*T450*T454))+y(39)*(-(params(11)*T462*T482));
residual(21) = (-params(7))*y(53)+y(52)+T33*y(52)*(-(T36*(1-exp(y(14)-y(31)))))+T33*y(55)*T36*exp((-y(31)));
residual(22) = y(54)*T142*params(4)*exp(y(4)*(params(4)-1))+y(53)+T33*(-(T36*(1-params(7))))*y(53);
residual(23) = (-y(74))+y(44)*(-exp(y(23)))+y(42)*(-(T474*T516*T517*exp(T460*y(30))*(1-params(11))*params(3)*T521))+y(41)*(-(T530*T472*T517*T521*exp(T460*y(30))*(1-params(11))*(1-params(3))))+y(40)*(-(T539*params(11)*T521))+exp(y(23))*y(39)+params(23)*y(74);
residual(24) = y(44)*exp(y(24))+params(23)*y(39)*(-(T482*T559))+params(23)*y(41)*(-(T530*T571))+params(23)*y(42)*T586+params(23)*y(43)*(-(exp(y(25)*(1-params(3)))*exp(T460*y(30))*params(3)*exp(y(24)*params(3))))+params(23)*y(44)*(-(exp(y(24))*(1-params(10))));
residual(25) = (T175-exp(y(2)))*T617+y(47)*(-(T617*params(1)/T21))+exp(y(25))*y(45)+y(43)*T630+y(42)*(-(T516*T517*T577*T634+T474*T516*T577*T567*T472*T634))+y(41)*(-(T530*T472*T564*T567*T472*T634+T472*T517*T564*T649))+y(39)*(-(T482*T655))+params(23)*y(47)*(-((-(T617*T21*params(1)))/(T21*T21)));
residual(26) = (T175-exp(y(2)))*exp(y(26))*T616+y(47)*(-(params(1)*exp(y(26))*T616/T21))+exp(y(26))*y(44)+params(23)*y(47)*(-((-(T21*params(1)*exp(y(26))*T616))/(T21*T21)));
residual(27) = y(42)*exp(y(27))+T33*y(46)*(-(T36*exp(y(27))));
residual(28) = y(45)*(-(T703*T708))+y(41)*exp(y(28));
residual(29) = T764;
residual(30) = y(67)+params(23)*y(67)*(-params(16))+y(43)*(-(exp(y(25)*(1-params(3)))*exp(y(24)*params(3))*T460*exp(T460*y(30))))+y(42)*(-(T474*T516*T517*T450*(1-params(11))*params(3)*T460*exp(T460*y(30))))+y(41)*(-(T530*T472*T517*T450*(1-params(11))*(1-params(3))*T460*exp(T460*y(30))))+y(39)*(-(T482*T791))+T798*y(67)*(-params(17));
residual(31) = T21*(-(exp(y(5))*params(6)*(-exp(y(38)-y(31)))*T809))+y(66)+T820+T824+T828+T832+y(44)*T840+T849+T859;
residual(32) = y(69);
residual(33) = y(70);
residual(34) = y(71);
residual(35) = y(72);
residual(36) = y(73);
residual(37) = y(74);
residual(38) = T21*(-(exp(y(5))*params(6)*exp(y(38)-y(31))*T809))+y(68)*exp(y(38));
residual(39) = exp(y(23))-T480^(params(2)/(params(2)-1));
residual(40) = exp(y(1))-params(11)*T450*T539;
residual(41) = exp(y(28))-T530*T472*T517*T564;
residual(42) = exp(y(27))-T474*T516*T517*T577;
residual(43) = exp(y(17))-exp(y(25)*(1-params(3)))*exp(T460*y(30))*exp(y(24)*params(3));
residual(44) = exp(y(10))*params(6)*exp((y(14)-y(31))*params(5))+exp(y(8))*params(6)*exp(params(5)*(y(15)-y(31)))+exp(y(9))*params(6)*exp(y(16)*params(5))+exp(y(4))+exp(y(2))+exp(y(3))+exp(y(26))+exp(y(24))-(exp(y(23))+exp(y(24))*(1-params(10)));
residual(45) = exp(y(25))-T703*exp(y(28))^(1/params(8));
residual(46) = 1-T36*(1+exp(y(27))-params(10));
residual(47) = T36-T21*params(1)/T21;
residual(48) = y(18)-T36*(exp(y(1))*exp(y(16))+(1-exp(y(16)))*y(18)-params(6)*exp(y(16)*params(5)));
residual(49) = y(19)-(y(19)*T36*(1-params(7))+params(7)*y(18));
residual(50) = y(19)*T111*params(4)*exp(y(3)*(params(4)-1))-1;
residual(51) = T726;
residual(52) = y(21)-T36*(exp(y(1))*exp(y(14)-y(31))+y(21)*(1-exp(y(14)-y(31)))-params(6)*exp((y(14)-y(31))*params(5)));
residual(53) = y(22)-(y(22)*T36*(1-params(7))+params(7)*y(21));
residual(54) = y(22)*T142*params(4)*exp(y(4)*(params(4)-1))-1;
residual(55) = T719;
residual(56) = exp(y(9))-(exp(y(9))*(1-exp(y(16)))+params(7)*exp(y(12)));
residual(57) = exp(y(8))-(exp(y(8))*(1-exp((-y(31)))*exp(y(15)))+exp(y(11))*params(7));
residual(58) = exp(y(10))-(exp(y(10))*(1-exp((-y(31)))*exp(y(14)))+params(7)*exp(y(13)));
residual(59) = exp(y(12))-((1-params(7))*exp(y(12))+T111*exp(params(4)*y(3)));
residual(60) = exp(y(11))-(exp(y(11))*(1-params(7))+T91*exp(y(2)*params(4)));
residual(61) = exp(y(13))-((1-params(7))*exp(y(13))+T142*exp(y(4)*params(4)));
residual(62) = exp(y(7))-exp(y(16))*exp(y(9));
residual(63) = exp(y(5))-exp(y(8))*exp((-y(31)))*exp(y(15));
residual(64) = exp(y(6))-exp(y(10))*exp((-y(31)))*exp(y(14));
residual(65) = exp(y(20))-(exp(y(6))+exp(y(5))+exp(y(7)));
residual(66) = y(31)-x(1);
residual(67) = y(30)-(x(2)+y(30)*params(16)+y(30)*params(17));
residual(68) = exp(y(38))-exp(y(15));
residual(69) = y(32);
residual(70) = y(33);
residual(71) = y(34);
residual(72) = y(35);
residual(73) = y(36);
residual(74) = y(37);
lhs =y(75);
rhs =y(67);
residual(75)= lhs-rhs;
lhs =y(76);
rhs =y(30);
residual(76)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(76, 76);

  %
  % Jacobian matrix
  %

T1024 = T33*y(55)*(-(exp(y(1))*T36*exp((-y(31)))))+T33*y(52)*(-(T36*exp(y(1))*exp(y(14)-y(31))))+T33*y(48)*(-(T36*exp(y(1))*exp(y(16))))+T33*y(51)*(-(exp(y(1))*T36));
T1033 = T33*y(52)*(-(T36*exp(y(1))*(-exp(y(14)-y(31)))))+T33*y(55)*(-(exp(y(1))*T36*(-exp((-y(31))))));
T1038 = (exp(y(2))*(exp(y(2))+exp(y(4)))-exp(y(2))*exp(y(2)))/((exp(y(2))+exp(y(4)))*(exp(y(2))+exp(y(4))));
T1053 = (-(exp(y(2))*exp(y(4))))/((exp(y(2))+exp(y(4)))*(exp(y(2))+exp(y(4))));
T1076 = (exp(y(4))*(exp(y(2))+exp(y(4)))-exp(y(4))*exp(y(4)))/((exp(y(2))+exp(y(4)))*(exp(y(2))+exp(y(4))));
T1099 = (exp(y(5))*(exp(y(5))+exp(y(6)))-exp(y(5))*exp(y(5)))/((exp(y(5))+exp(y(6)))*(exp(y(5))+exp(y(6))));
T1109 = (-(exp(y(5))*exp(y(6))))/((exp(y(5))+exp(y(6)))*(exp(y(5))+exp(y(6))));
T1120 = (exp(y(6))*(exp(y(5))+exp(y(6)))-exp(y(6))*exp(y(6)))/((exp(y(5))+exp(y(6)))*(exp(y(5))+exp(y(6))));
T1132 = params(23)*y(62)*(-(exp(y(16))*exp(y(9))))+params(23)*y(44)*exp(y(9))*params(6)*params(5)*exp(y(16)*params(5))+params(23)*y(56)*(-(exp(y(9))*(-exp(y(16)))));
T1135 = T294+params(23)*y(44)*exp(y(10))*params(6)*params(5)*exp((y(14)-y(31))*params(5))+params(23)*y(58)*(-(exp(y(10))*(-(exp((-y(31)))*exp(y(14))))));
T1239 = getPowerDeriv(T480,params(2)/(params(2)-1),2);
T1275 = T521+exp(y(23))*exp(y(23))*getPowerDeriv(exp(y(23)),1/params(2),2);
T1302 = y(41)*(-(T530*(T517*T521*exp(T460*y(30))*(1-params(11))*(1-params(3))*T555+T472*T521*exp(T460*y(30))*(1-params(11))*(1-params(3))*T568)));
T1310 = y(42)*(-(T474*(T516*exp(T460*y(30))*(1-params(11))*params(3)*T521*T568+T517*exp(T460*y(30))*(1-params(11))*params(3)*T521*T582)));
T1327 = y(42)*(-(T516*T517*exp(T460*y(30))*(1-params(11))*params(3)*T521*T634+T474*T516*exp(T460*y(30))*(1-params(11))*params(3)*T521*T567*T472*T634))+y(41)*(-(T530*T472*T521*exp(T460*y(30))*(1-params(11))*(1-params(3))*T567*T472*T634+T472*T517*T521*exp(T460*y(30))*(1-params(11))*(1-params(3))*T649));
T1340 = y(42)*(-(T474*T516*T517*T521*(1-params(11))*params(3)*T460*exp(T460*y(30))))+y(41)*(-(T530*T472*T517*T521*(1-params(11))*(1-params(3))*T460*exp(T460*y(30))));
T1349 = T555+exp(y(24))*exp(y(24))*getPowerDeriv(exp(y(24)),params(3),2);
T1351 = getPowerDeriv(T475,T460,2);
T1366 = getPowerDeriv(T475,T452,2);
T1370 = T567*T474*T1349+T474*T555*T474*T555*T1366;
T1452 = y(42)*(-(T474*(T582*T517*T450*(1-params(11))*params(3)*T460*exp(T460*y(30))+T516*T568*T450*(1-params(11))*params(3)*T460*exp(T460*y(30)))));
T1459 = y(41)*(-(T530*(T555*T517*T450*(1-params(11))*(1-params(3))*T460*exp(T460*y(30))+T472*T568*T450*(1-params(11))*(1-params(3))*T460*exp(T460*y(30)))));
T1514 = getPowerDeriv(T18,(-params(15)),2);
T1518 = T616*(-(params(9)*(T612+exp(y(25))*exp(y(25))*getPowerDeriv(exp(y(25)),1+params(8),2))/(1+params(8))))+T615*T615*T1514;
T1534 = T634+exp(y(25))*exp(y(25))*getPowerDeriv(exp(y(25)),1-params(3),2);
T1623 = y(42)*(-(T634*T516*T517*T450*(1-params(11))*params(3)*T460*exp(T460*y(30))+T474*T516*T567*T472*T634*T450*(1-params(11))*params(3)*T460*exp(T460*y(30))));
T1630 = y(41)*(-(T649*T472*T517*T450*(1-params(11))*(1-params(3))*T460*exp(T460*y(30))+T530*T472*T567*T472*T634*T450*(1-params(11))*(1-params(3))*T460*exp(T460*y(30))));
T1796 = getPowerDeriv(exp(y(38)-y(31)),params(5)-1,2);
  g1(1,1)=T21*exp(y(1))*exp(y(5))+T70;
  g1(1,5)=T21*exp(y(1))*exp(y(5));
  g1(1,14)=T33*y(52)*(-(T36*exp(y(1))*exp(y(14)-y(31))));
  g1(1,16)=T33*y(48)*(-(T36*exp(y(1))*exp(y(16))));
  g1(1,25)=exp(y(1))*exp(y(5))*T617;
  g1(1,26)=exp(y(1))*exp(y(5))*exp(y(26))*T616;
  g1(1,29)=T1024;
  g1(1,31)=T1033;
  g1(1,40)=exp(y(1));
  g1(1,48)=T33*(-(T36*exp(y(1))*exp(y(16))));
  g1(1,51)=T33*(-(exp(y(1))*T36));
  g1(1,52)=T33*(-(T36*exp(y(1))*exp(y(14)-y(31))));
  g1(1,55)=T33*(-(exp(y(1))*T36*exp((-y(31)))));
  g1(1,69)=(-1)+params(23);
  g1(2,2)=T21*(-exp(y(2)))+y(71)*(-T1038)+exp(y(2))*y(44)+y(60)*(-(T91*params(4)*params(4)*exp(y(2)*params(4))))+params(23)*y(71)*T1038;
  g1(2,4)=y(71)*(-T1053)+params(23)*y(71)*T1053;
  g1(2,25)=(-exp(y(2)))*T617;
  g1(2,26)=(-exp(y(2)))*exp(y(26))*T616;
  g1(2,44)=exp(y(2));
  g1(2,60)=(-(T91*params(4)*exp(y(2)*params(4))));
  g1(2,71)=(-T84)+params(23)*T84;
  g1(3,3)=y(59)*(-(T111*params(4)*params(4)*exp(params(4)*y(3))))+y(44)*exp(y(3))+y(50)*y(19)*T111*params(4)*(params(4)-1)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(3,19)=y(50)*T111*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(3,44)=exp(y(3));
  g1(3,50)=y(19)*T111*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(3,59)=(-(T111*params(4)*exp(params(4)*y(3))));
  g1(3,70)=(-1)+params(23);
  g1(4,2)=y(71)*(-T1053)+params(23)*y(71)*T1053;
  g1(4,4)=y(71)*(-T1076)+y(61)*(-(T142*params(4)*params(4)*exp(y(4)*params(4))))+exp(y(4))*y(44)+y(54)*y(22)*T142*params(4)*(params(4)-1)*(params(4)-1)*exp(y(4)*(params(4)-1))+params(23)*y(71)*T1076;
  g1(4,22)=y(54)*T142*params(4)*(params(4)-1)*exp(y(4)*(params(4)-1));
  g1(4,44)=exp(y(4));
  g1(4,54)=y(22)*T142*params(4)*(params(4)-1)*exp(y(4)*(params(4)-1));
  g1(4,61)=(-(T142*params(4)*exp(y(4)*params(4))));
  g1(4,71)=(-T137)+params(23)*T137;
  g1(5,1)=T21*exp(y(1))*exp(y(5));
  g1(5,5)=T21*T175+y(73)*(-T1099)+y(65)*(-exp(y(5)))+exp(y(5))*y(63)+params(23)*y(73)*T1099;
  g1(5,6)=y(73)*(-T1109)+params(23)*y(73)*T1109;
  g1(5,25)=T175*T617;
  g1(5,26)=T175*exp(y(26))*T616;
  g1(5,31)=T21*(-(exp(y(5))*params(6)*(-exp(y(38)-y(31)))*T809));
  g1(5,38)=T21*(-(exp(y(5))*params(6)*exp(y(38)-y(31))*T809));
  g1(5,63)=exp(y(5));
  g1(5,65)=(-exp(y(5)));
  g1(5,73)=(-T181)+params(23)*T181;
  g1(6,5)=y(73)*(-T1109)+params(23)*y(73)*T1109;
  g1(6,6)=y(73)*(-T1120)+y(65)*(-exp(y(6)))+exp(y(6))*y(64)+params(23)*y(73)*T1120;
  g1(6,64)=exp(y(6));
  g1(6,65)=(-exp(y(6)));
  g1(6,73)=(-T196)+params(23)*T196;
  g1(7,7)=y(65)*(-exp(y(7)))+exp(y(7))*y(62);
  g1(7,62)=exp(y(7));
  g1(7,65)=(-exp(y(7)));
  g1(7,72)=(-1)+params(23);
  g1(8,8)=T247;
  g1(8,15)=T379;
  g1(8,31)=params(23)*y(44)*exp(y(8))*params(6)*exp(params(5)*(y(15)-y(31)))*(-params(5))+params(23)*T832+params(23)*T824;
  g1(8,44)=params(23)*exp(y(8))*params(6)*exp(params(5)*(y(15)-y(31)));
  g1(8,57)=exp(y(8))+params(23)*(-(exp(y(8))*(1-exp((-y(31)))*exp(y(15)))));
  g1(8,63)=params(23)*(-(exp(y(8))*exp((-y(31)))*exp(y(15))));
  g1(9,9)=T270;
  g1(9,16)=T1132;
  g1(9,44)=params(23)*exp(y(9))*params(6)*exp(y(16)*params(5));
  g1(9,56)=exp(y(9))+params(23)*(-(exp(y(9))*(1-exp(y(16)))));
  g1(9,62)=params(23)*(-(exp(y(16))*exp(y(9))));
  g1(10,10)=T295;
  g1(10,14)=T1135;
  g1(10,31)=params(23)*y(44)*exp(y(10))*params(6)*exp((y(14)-y(31))*params(5))*(-params(5))+params(23)*T828+params(23)*T820;
  g1(10,44)=params(23)*exp(y(10))*params(6)*exp((y(14)-y(31))*params(5));
  g1(10,58)=exp(y(10))+params(23)*(-(exp(y(10))*(1-exp((-y(31)))*exp(y(14)))));
  g1(10,64)=params(23)*(-(exp(y(10))*exp((-y(31)))*exp(y(14))));
  g1(11,11)=y(60)*exp(y(11))+y(57)*(-(exp(y(11))*params(7)))+params(23)*y(60)*(-(exp(y(11))*(1-params(7))));
  g1(11,57)=(-(exp(y(11))*params(7)));
  g1(11,60)=exp(y(11))+params(23)*(-(exp(y(11))*(1-params(7))));
  g1(12,12)=y(59)*exp(y(12))+y(56)*(-(params(7)*exp(y(12))))+params(23)*y(59)*(-((1-params(7))*exp(y(12))));
  g1(12,56)=(-(params(7)*exp(y(12))));
  g1(12,59)=exp(y(12))+params(23)*(-((1-params(7))*exp(y(12))));
  g1(13,13)=y(61)*exp(y(13))+y(58)*(-(params(7)*exp(y(13))))+params(23)*y(61)*(-((1-params(7))*exp(y(13))));
  g1(13,58)=(-(params(7)*exp(y(13))));
  g1(13,61)=exp(y(13))+params(23)*(-((1-params(7))*exp(y(13))));
  g1(14,1)=y(52)*(-(T36*exp(y(1))*exp(y(14)-y(31))));
  g1(14,10)=T1135;
  g1(14,14)=T294+params(23)*y(58)*(-(exp(y(10))*(-(exp((-y(31)))*exp(y(14))))))+y(55)*T36*params(6)*params(5)*(params(5)-1)*(params(5)-1)*exp((y(14)-y(31))*(params(5)-1))+y(52)*(-(T36*(exp(y(1))*exp(y(14)-y(31))+y(21)*(-exp(y(14)-y(31)))-params(6)*params(5)*params(5)*exp((y(14)-y(31))*params(5)))))+params(23)*y(44)*exp(y(10))*params(6)*params(5)*params(5)*exp((y(14)-y(31))*params(5));
  g1(14,21)=y(52)*(-(T36*(-exp(y(14)-y(31)))));
  g1(14,29)=y(55)*T36*params(6)*params(5)*(params(5)-1)*exp((y(14)-y(31))*(params(5)-1))+T354;
  g1(14,31)=params(23)*T820+params(23)*T828+y(55)*T36*params(6)*params(5)*(params(5)-1)*exp((y(14)-y(31))*(params(5)-1))*(-(params(5)-1))+y(52)*(-(T36*(exp(y(1))*(-exp(y(14)-y(31)))+exp(y(14)-y(31))*y(21)-params(6)*params(5)*exp((y(14)-y(31))*params(5))*(-params(5)))))+params(23)*y(44)*exp(y(10))*params(6)*params(5)*exp((y(14)-y(31))*params(5))*(-params(5));
  g1(14,44)=params(23)*exp(y(10))*params(6)*params(5)*exp((y(14)-y(31))*params(5));
  g1(14,52)=T353;
  g1(14,55)=T36*params(6)*params(5)*(params(5)-1)*exp((y(14)-y(31))*(params(5)-1));
  g1(14,58)=params(23)*(-(exp(y(10))*(-(exp((-y(31)))*exp(y(14))))));
  g1(14,64)=params(23)*(-(exp(y(10))*exp((-y(31)))*exp(y(14))));
  g1(15,8)=T379;
  g1(15,15)=params(23)*y(68)*(-exp(y(15)))+params(23)*y(63)*(-(exp(y(8))*exp((-y(31)))*exp(y(15))))+params(23)*y(57)*(-(exp(y(8))*(-(exp((-y(31)))*exp(y(15))))))+params(23)*y(44)*exp(y(8))*params(6)*params(5)*params(5)*exp(params(5)*(y(15)-y(31)));
  g1(15,31)=params(23)*T824+params(23)*T832+params(23)*y(44)*exp(y(8))*params(6)*params(5)*exp(params(5)*(y(15)-y(31)))*(-params(5));
  g1(15,44)=params(23)*exp(y(8))*params(6)*params(5)*exp(params(5)*(y(15)-y(31)));
  g1(15,57)=params(23)*(-(exp(y(8))*(-(exp((-y(31)))*exp(y(15))))));
  g1(15,63)=params(23)*(-(exp(y(8))*exp((-y(31)))*exp(y(15))));
  g1(15,68)=params(23)*(-exp(y(15)));
  g1(16,1)=y(48)*(-(T36*exp(y(1))*exp(y(16))));
  g1(16,9)=T1132;
  g1(16,16)=params(23)*y(62)*(-(exp(y(16))*exp(y(9))))+params(23)*y(56)*(-(exp(y(9))*(-exp(y(16)))))+y(51)*T36*params(6)*params(5)*(params(5)-1)*(params(5)-1)*exp(y(16)*(params(5)-1))+y(48)*(-(T36*(exp(y(1))*exp(y(16))+y(18)*(-exp(y(16)))-params(6)*params(5)*params(5)*exp(y(16)*params(5)))))+params(23)*y(44)*exp(y(9))*params(6)*params(5)*params(5)*exp(y(16)*params(5));
  g1(16,18)=y(48)*(-(T36*(-exp(y(16)))));
  g1(16,29)=y(51)*T36*params(6)*params(5)*(params(5)-1)*exp(y(16)*(params(5)-1))+T401;
  g1(16,44)=params(23)*exp(y(9))*params(6)*params(5)*exp(y(16)*params(5));
  g1(16,48)=T400;
  g1(16,51)=T36*params(6)*params(5)*(params(5)-1)*exp(y(16)*(params(5)-1));
  g1(16,56)=params(23)*(-(exp(y(9))*(-exp(y(16)))));
  g1(16,62)=params(23)*(-(exp(y(16))*exp(y(9))));
  g1(17,17)=exp(y(17))*y(43);
  g1(17,43)=exp(y(17));
  g1(18,16)=T33*y(48)*(-(T36*(-exp(y(16)))));
  g1(18,29)=T33*y(48)*(-(T36*(1-exp(y(16)))))+T33*T36*y(51);
  g1(18,48)=1+T33*(-(T36*(1-exp(y(16)))));
  g1(18,49)=(-params(7));
  g1(18,51)=T33*T36;
  g1(19,3)=y(50)*T111*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(19,29)=T33*y(49)*(-(T36*(1-params(7))));
  g1(19,49)=1+T33*(-(T36*(1-params(7))));
  g1(19,50)=T111*params(4)*exp(y(3)*(params(4)-1));
  g1(20,20)=y(65)*exp(y(20))+y(40)*(-(params(11)*T450*(T454+exp(y(20))*exp(y(20))*getPowerDeriv(exp(y(20)),T452,2))))+y(39)*(-(T482*params(11)*(T462+exp(y(20))*exp(y(20))*getPowerDeriv(exp(y(20)),T460,2))+params(11)*T462*params(11)*T462*T1239));
  g1(20,23)=y(40)*(-(T454*params(11)*T521));
  g1(20,24)=y(39)*(-(params(11)*T462*T559*T1239));
  g1(20,25)=y(39)*(-(params(11)*T462*T655*T1239));
  g1(20,30)=y(39)*(-(params(11)*T462*T791*T1239));
  g1(20,39)=(-(params(11)*T462*T482));
  g1(20,40)=(-(params(11)*T450*T454));
  g1(20,65)=exp(y(20));
  g1(21,14)=T33*y(52)*(-(T36*(-exp(y(14)-y(31)))));
  g1(21,29)=T33*y(52)*(-(T36*(1-exp(y(14)-y(31)))))+T33*y(55)*T36*exp((-y(31)));
  g1(21,31)=T33*y(52)*(-(T36*exp(y(14)-y(31))))+T33*y(55)*T36*(-exp((-y(31))));
  g1(21,52)=1+T33*(-(T36*(1-exp(y(14)-y(31)))));
  g1(21,53)=(-params(7));
  g1(21,55)=T33*T36*exp((-y(31)));
  g1(22,4)=y(54)*T142*params(4)*(params(4)-1)*exp(y(4)*(params(4)-1));
  g1(22,29)=T33*(-(T36*(1-params(7))))*y(53);
  g1(22,53)=1+T33*(-(T36*(1-params(7))));
  g1(22,54)=T142*params(4)*exp(y(4)*(params(4)-1));
  g1(23,20)=y(40)*(-(T454*params(11)*T521));
  g1(23,23)=y(44)*(-exp(y(23)))+y(42)*(-(T474*T516*T517*exp(T460*y(30))*(1-params(11))*params(3)*T1275))+y(41)*(-(T530*T472*T517*exp(T460*y(30))*(1-params(11))*(1-params(3))*T1275))+exp(y(23))*y(39)+y(40)*(-(T539*params(11)*T1275));
  g1(23,24)=T1302+T1310;
  g1(23,25)=T1327;
  g1(23,30)=T1340;
  g1(23,39)=exp(y(23));
  g1(23,40)=(-(T539*params(11)*T521));
  g1(23,41)=(-(T530*T472*T517*T521*exp(T460*y(30))*(1-params(11))*(1-params(3))));
  g1(23,42)=(-(T474*T516*T517*exp(T460*y(30))*(1-params(11))*params(3)*T521));
  g1(23,44)=(-exp(y(23)));
  g1(23,74)=(-1)+params(23);
  g1(24,20)=params(23)*y(39)*(-(T559*params(11)*T462*T1239));
  g1(24,23)=params(23)*T1302+params(23)*T1310;
  g1(24,24)=y(44)*exp(y(24))+params(23)*y(44)*(-(exp(y(24))*(1-params(10))))+params(23)*y(39)*(-(T559*T559*T1239+T482*(1-params(11))*exp(T460*y(30))*(T557*T474*T1349+T474*T555*T474*T555*T1351)))+params(23)*y(41)*(-(T530*(T517*T564*T1349+T555*T564*T568+T555*T564*T568+T472*T564*T1370)))+params(23)*y(42)*(-(T474*(T568*T577*T582+T516*T577*T1370+T568*T577*T582+T517*T577*(T582+exp(y(24))*exp(y(24))*getPowerDeriv(exp(y(24)),params(3)-1,2)))))+params(23)*y(43)*(-(exp(y(25)*(1-params(3)))*exp(T460*y(30))*params(3)*params(3)*exp(y(24)*params(3))));
  g1(24,25)=params(23)*y(39)*(-(T559*T655*T1239+T482*(1-params(11))*exp(T460*y(30))*(T557*T555*T634+T474*T555*T472*T634*T1351)))+params(23)*y(41)*(-(T571*T649+T530*(T555*T564*T567*T472*T634+T472*T564*(T567*T555*T634+T474*T555*T472*T634*T1366))))+params(23)*y(42)*(-((T516*T568*T577+T517*T577*T582)*T634+T474*(T582*T577*T567*T472*T634+T516*T577*(T567*T555*T634+T474*T555*T472*T634*T1366))))+params(23)*y(43)*(-(exp(T460*y(30))*params(3)*exp(y(24)*params(3))*(1-params(3))*exp(y(25)*(1-params(3)))));
  g1(24,30)=params(23)*y(39)*(-(T482*T474*T555*T557*(1-params(11))*T460*exp(T460*y(30))+T559*T791*T1239))+params(23)*T1459+params(23)*T1452+params(23)*y(43)*(-(exp(y(25)*(1-params(3)))*params(3)*exp(y(24)*params(3))*T460*exp(T460*y(30))));
  g1(24,39)=params(23)*(-(T482*T559));
  g1(24,41)=params(23)*(-(T530*T571));
  g1(24,42)=params(23)*T586;
  g1(24,43)=params(23)*(-(exp(y(25)*(1-params(3)))*exp(T460*y(30))*params(3)*exp(y(24)*params(3))));
  g1(24,44)=exp(y(24))+params(23)*(-(exp(y(24))*(1-params(10))));
  g1(25,1)=exp(y(1))*exp(y(5))*T617;
  g1(25,2)=(-exp(y(2)))*T617;
  g1(25,5)=T175*T617;
  g1(25,20)=y(39)*(-(T655*params(11)*T462*T1239));
  g1(25,23)=T1327;
  g1(25,24)=y(43)*(-(exp(T460*y(30))*params(3)*exp(y(24)*params(3))*(1-params(3))*exp(y(25)*(1-params(3)))))+y(42)*(-((T516*T568*T577+T517*T577*T582)*T634+T474*(T582*T577*T567*T472*T634+T516*T577*(T472*T634*T474*T555*T1366+T567*T555*T634))))+y(41)*(-(T530*(T555*T564*T567*T472*T634+T472*T564*(T472*T634*T474*T555*T1366+T567*T555*T634))+T571*T649))+y(39)*(-(T655*T559*T1239+T482*(1-params(11))*exp(T460*y(30))*(T472*T634*T474*T555*T1351+T557*T555*T634)));
  g1(25,25)=(T175-exp(y(2)))*T1518+y(47)*(-((T21*params(1)*T1518-T617*T617*params(1))/(T21*T21)))+exp(y(25))*y(45)+y(43)*(-(exp(T460*y(30))*exp(y(24)*params(3))*(1-params(3))*(1-params(3))*exp(y(25)*(1-params(3)))))+y(42)*(-(T634*T516*T577*T567*T472*T634+T516*T517*T577*T1534+T634*T516*T577*T567*T472*T634+T474*T516*T577*(T472*T634*T472*T634*T1366+T567*T472*T1534)))+y(41)*(-(T472*T564*T567*T472*T634*T649+T530*T472*T564*(T472*T634*T472*T634*T1366+T567*T472*T1534)+T472*T564*T567*T472*T634*T649+T472*T517*T564*(T649+exp(y(25))*exp(y(25))*getPowerDeriv(exp(y(25)),(-params(3)),2))))+y(39)*(-(T655*T655*T1239+T482*(1-params(11))*exp(T460*y(30))*(T472*T634*T472*T634*T1351+T557*T472*T1534)))+params(23)*y(47)*(-((T21*T21*(-(T617*T617*params(1)+T21*params(1)*T1518))-(-(T617*T21*params(1)))*(T21*T617+T21*T617))/(T21*T21*T21*T21)));
  g1(25,26)=(T175-exp(y(2)))*T615*exp(y(26))*T1514+y(47)*(-((T21*params(1)*T615*exp(y(26))*T1514-T617*params(1)*exp(y(26))*T616)/(T21*T21)))+params(23)*y(47)*(-((T21*T21*(-(T617*params(1)*exp(y(26))*T616+T21*params(1)*T615*exp(y(26))*T1514))-(-(T617*T21*params(1)))*(T21*exp(y(26))*T616+T21*exp(y(26))*T616))/(T21*T21*T21*T21)));
  g1(25,30)=y(43)*(-((1-params(3))*exp(y(25)*(1-params(3)))*exp(y(24)*params(3))*T460*exp(T460*y(30))))+T1623+T1630+y(39)*(-(T482*T557*T472*T634*(1-params(11))*T460*exp(T460*y(30))+T655*T791*T1239));
  g1(25,31)=T617*(-(exp(y(5))*params(6)*(-exp(y(38)-y(31)))*T809));
  g1(25,38)=T617*(-(exp(y(5))*params(6)*exp(y(38)-y(31))*T809));
  g1(25,39)=(-(T482*T655));
  g1(25,41)=(-(T530*T472*T564*T567*T472*T634+T472*T517*T564*T649));
  g1(25,42)=(-(T516*T517*T577*T634+T474*T516*T577*T567*T472*T634));
  g1(25,43)=T630;
  g1(25,45)=exp(y(25));
  g1(25,47)=(-(T617*params(1)/T21))+params(23)*(-((-(T617*T21*params(1)))/(T21*T21)));
  g1(26,1)=exp(y(1))*exp(y(5))*exp(y(26))*T616;
  g1(26,2)=(-exp(y(2)))*exp(y(26))*T616;
  g1(26,5)=T175*exp(y(26))*T616;
  g1(26,25)=(T175-exp(y(2)))*exp(y(26))*T615*T1514+y(47)*(-((T21*params(1)*exp(y(26))*T615*T1514-T617*params(1)*exp(y(26))*T616)/(T21*T21)))+params(23)*y(47)*(-((T21*T21*(-(T617*params(1)*exp(y(26))*T616+T21*params(1)*exp(y(26))*T615*T1514))-(-(T21*params(1)*exp(y(26))*T616))*(T21*T617+T21*T617))/(T21*T21*T21*T21)));
  g1(26,26)=(T175-exp(y(2)))*(exp(y(26))*T616+exp(y(26))*exp(y(26))*T1514)+y(47)*(-((T21*params(1)*(exp(y(26))*T616+exp(y(26))*exp(y(26))*T1514)-exp(y(26))*T616*params(1)*exp(y(26))*T616)/(T21*T21)))+exp(y(26))*y(44)+params(23)*y(47)*(-((T21*T21*(-(exp(y(26))*T616*params(1)*exp(y(26))*T616+T21*params(1)*(exp(y(26))*T616+exp(y(26))*exp(y(26))*T1514)))-(-(T21*params(1)*exp(y(26))*T616))*(T21*exp(y(26))*T616+T21*exp(y(26))*T616))/(T21*T21*T21*T21)));
  g1(26,31)=exp(y(26))*T616*(-(exp(y(5))*params(6)*(-exp(y(38)-y(31)))*T809));
  g1(26,38)=exp(y(26))*T616*(-(exp(y(5))*params(6)*exp(y(38)-y(31))*T809));
  g1(26,44)=exp(y(26));
  g1(26,47)=(-(params(1)*exp(y(26))*T616/T21))+params(23)*(-((-(T21*params(1)*exp(y(26))*T616))/(T21*T21)));
  g1(27,27)=y(42)*exp(y(27))+T33*y(46)*(-(T36*exp(y(27))));
  g1(27,29)=T33*y(46)*(-(T36*exp(y(27))));
  g1(27,42)=exp(y(27));
  g1(27,46)=T33*(-(T36*exp(y(27))));
  g1(28,28)=y(41)*exp(y(28))+y(45)*(-(T703*(T708+exp(y(28))*exp(y(28))*getPowerDeriv(exp(y(28)),1/params(8),2))));
  g1(28,41)=exp(y(28));
  g1(28,45)=(-(T703*T708));
  g1(29,1)=T1024;
  g1(29,14)=T33*y(55)*T36*params(6)*params(5)*(params(5)-1)*exp((y(14)-y(31))*(params(5)-1))+T33*T354;
  g1(29,16)=T33*y(51)*T36*params(6)*params(5)*(params(5)-1)*exp(y(16)*(params(5)-1))+T33*T401;
  g1(29,18)=T33*y(48)*(-(T36*(1-exp(y(16)))))+T33*T36*y(51);
  g1(29,19)=T33*y(49)*(-(T36*(1-params(7))));
  g1(29,21)=T33*y(52)*(-(T36*(1-exp(y(14)-y(31)))))+T33*y(55)*T36*exp((-y(31)));
  g1(29,22)=T33*(-(T36*(1-params(7))))*y(53);
  g1(29,27)=T33*y(46)*(-(T36*exp(y(27))));
  g1(29,29)=T764;
  g1(29,31)=T849+T859;
  g1(29,46)=T33*(-(T36*(1+exp(y(27))-params(10))));
  g1(29,47)=T36;
  g1(29,48)=T33*T741;
  g1(29,49)=T33*(-(y(19)*T36*(1-params(7))));
  g1(29,51)=T33*T726;
  g1(29,52)=T33*T755;
  g1(29,53)=T33*(-(y(22)*T36*(1-params(7))));
  g1(29,55)=T33*T719;
  g1(30,20)=y(39)*(-(T791*params(11)*T462*T1239));
  g1(30,23)=T1340;
  g1(30,24)=y(43)*(-(exp(y(25)*(1-params(3)))*params(3)*exp(y(24)*params(3))*T460*exp(T460*y(30))))+T1452+T1459+y(39)*(-(T791*T559*T1239+T482*T474*T555*T557*(1-params(11))*T460*exp(T460*y(30))));
  g1(30,25)=y(43)*(-((1-params(3))*exp(y(25)*(1-params(3)))*exp(y(24)*params(3))*T460*exp(T460*y(30))))+T1623+T1630+y(39)*(-(T791*T655*T1239+T482*T557*T472*T634*(1-params(11))*T460*exp(T460*y(30))));
  g1(30,30)=y(43)*(-(exp(y(25)*(1-params(3)))*exp(y(24)*params(3))*T460*T460*exp(T460*y(30))))+y(42)*(-(T474*T516*T517*T450*(1-params(11))*params(3)*T460*T460*exp(T460*y(30))))+y(41)*(-(T530*T472*T517*T450*(1-params(11))*(1-params(3))*T460*T460*exp(T460*y(30))))+y(39)*(-(T791*T791*T1239+T482*T476*(1-params(11))*T460*T460*exp(T460*y(30))));
  g1(30,39)=(-(T482*T791));
  g1(30,41)=(-(T530*T472*T517*T450*(1-params(11))*(1-params(3))*T460*exp(T460*y(30))));
  g1(30,42)=(-(T474*T516*T517*T450*(1-params(11))*params(3)*T460*exp(T460*y(30))));
  g1(30,43)=(-(exp(y(25)*(1-params(3)))*exp(y(24)*params(3))*T460*exp(T460*y(30))));
  g1(30,67)=1+params(23)*(-params(16))+T798*(-params(17));
  g1(31,1)=T1033;
  g1(31,5)=T21*(-(exp(y(5))*params(6)*(-exp(y(38)-y(31)))*T809));
  g1(31,8)=T824+T832+y(44)*exp(y(8))*params(6)*exp(params(5)*(y(15)-y(31)))*(-params(5));
  g1(31,10)=T820+T828+y(44)*exp(y(10))*params(6)*exp((y(14)-y(31))*params(5))*(-params(5));
  g1(31,14)=T820+T828+y(44)*exp(y(10))*params(6)*params(5)*exp((y(14)-y(31))*params(5))*(-params(5))+T33*y(52)*(-(T36*(exp(y(1))*(-exp(y(14)-y(31)))+exp(y(14)-y(31))*y(21)-params(6)*params(5)*exp((y(14)-y(31))*params(5))*(-params(5)))))+T33*y(55)*T36*params(6)*params(5)*(params(5)-1)*exp((y(14)-y(31))*(params(5)-1))*(-(params(5)-1));
  g1(31,15)=T824+T832+y(44)*exp(y(8))*params(6)*params(5)*exp(params(5)*(y(15)-y(31)))*(-params(5));
  g1(31,21)=T33*y(52)*(-(T36*exp(y(14)-y(31))))+T33*y(55)*T36*(-exp((-y(31))));
  g1(31,25)=T617*(-(exp(y(5))*params(6)*(-exp(y(38)-y(31)))*T809));
  g1(31,26)=exp(y(26))*T616*(-(exp(y(5))*params(6)*(-exp(y(38)-y(31)))*T809));
  g1(31,29)=T849+T859;
  g1(31,31)=T21*(-(exp(y(5))*params(6)*(exp(y(38)-y(31))*T809+(-exp(y(38)-y(31)))*(-exp(y(38)-y(31)))*T1796)))+y(64)*(-(exp(y(10))*exp((-y(31)))*exp(y(14))))+y(63)*(-(exp(y(8))*exp((-y(31)))*exp(y(15))))+y(58)*(-(exp(y(10))*(-(exp((-y(31)))*exp(y(14))))))+y(57)*(-(exp(y(8))*(-(exp((-y(31)))*exp(y(15))))))+y(44)*(exp(y(8))*params(6)*(-params(5))*exp(params(5)*(y(15)-y(31)))*(-params(5))+exp(y(10))*params(6)*(-params(5))*exp((y(14)-y(31))*params(5))*(-params(5)))+T33*y(52)*(-(T36*(exp(y(1))*exp(y(14)-y(31))+y(21)*(-exp(y(14)-y(31)))-params(6)*(-params(5))*exp((y(14)-y(31))*params(5))*(-params(5)))))+T33*y(55)*(T36*params(6)*params(5)*(-(params(5)-1))*exp((y(14)-y(31))*(params(5)-1))*(-(params(5)-1))-T36*exp((-y(31)))*(exp(y(1))-y(21)));
  g1(31,38)=T21*(-(exp(y(5))*params(6)*((-exp(y(38)-y(31)))*T809+(-exp(y(38)-y(31)))*exp(y(38)-y(31))*T1796)));
  g1(31,44)=T840;
  g1(31,52)=T33*T847;
  g1(31,55)=T33*T857;
  g1(31,57)=(-(exp(y(8))*(-(exp(y(15))*(-exp((-y(31))))))));
  g1(31,58)=(-(exp(y(10))*(-(exp(y(14))*(-exp((-y(31))))))));
  g1(31,63)=(-(exp(y(8))*exp(y(15))*(-exp((-y(31))))));
  g1(31,64)=(-(exp(y(10))*exp(y(14))*(-exp((-y(31))))));
  g1(31,66)=1;
  g1(32,69)=1;
  g1(33,70)=1;
  g1(34,71)=1;
  g1(35,72)=1;
  g1(36,73)=1;
  g1(37,74)=1;
  g1(38,5)=T21*(-(exp(y(5))*params(6)*exp(y(38)-y(31))*T809));
  g1(38,25)=T617*(-(exp(y(5))*params(6)*exp(y(38)-y(31))*T809));
  g1(38,26)=exp(y(26))*T616*(-(exp(y(5))*params(6)*exp(y(38)-y(31))*T809));
  g1(38,31)=T21*(-(exp(y(5))*params(6)*((-exp(y(38)-y(31)))*T809+exp(y(38)-y(31))*(-exp(y(38)-y(31)))*T1796)));
  g1(38,38)=y(68)*exp(y(38))+T21*(-(exp(y(5))*params(6)*(exp(y(38)-y(31))*T809+exp(y(38)-y(31))*exp(y(38)-y(31))*T1796)));
  g1(38,68)=exp(y(38));
  g1(39,20)=(-(params(11)*T462*T482));
  g1(39,23)=exp(y(23));
  g1(39,24)=(-(T482*T559));
  g1(39,25)=(-(T482*T655));
  g1(39,30)=(-(T482*T791));
  g1(40,1)=exp(y(1));
  g1(40,20)=(-(params(11)*T450*T454));
  g1(40,23)=(-(T539*params(11)*T521));
  g1(41,23)=(-(T530*T472*T517*T521*exp(T460*y(30))*(1-params(11))*(1-params(3))));
  g1(41,24)=(-(T530*T571));
  g1(41,25)=(-(T530*T472*T564*T567*T472*T634+T472*T517*T564*T649));
  g1(41,28)=exp(y(28));
  g1(41,30)=(-(T530*T472*T517*T450*(1-params(11))*(1-params(3))*T460*exp(T460*y(30))));
  g1(42,23)=(-(T474*T516*T517*exp(T460*y(30))*(1-params(11))*params(3)*T521));
  g1(42,24)=T586;
  g1(42,25)=(-(T516*T517*T577*T634+T474*T516*T577*T567*T472*T634));
  g1(42,27)=exp(y(27));
  g1(42,30)=(-(T474*T516*T517*T450*(1-params(11))*params(3)*T460*exp(T460*y(30))));
  g1(43,17)=exp(y(17));
  g1(43,24)=(-(exp(y(25)*(1-params(3)))*exp(T460*y(30))*params(3)*exp(y(24)*params(3))));
  g1(43,25)=T630;
  g1(43,30)=(-(exp(y(25)*(1-params(3)))*exp(y(24)*params(3))*T460*exp(T460*y(30))));
  g1(44,2)=exp(y(2));
  g1(44,3)=exp(y(3));
  g1(44,4)=exp(y(4));
  g1(44,8)=exp(y(8))*params(6)*exp(params(5)*(y(15)-y(31)));
  g1(44,9)=exp(y(9))*params(6)*exp(y(16)*params(5));
  g1(44,10)=exp(y(10))*params(6)*exp((y(14)-y(31))*params(5));
  g1(44,14)=exp(y(10))*params(6)*params(5)*exp((y(14)-y(31))*params(5));
  g1(44,15)=exp(y(8))*params(6)*params(5)*exp(params(5)*(y(15)-y(31)));
  g1(44,16)=exp(y(9))*params(6)*params(5)*exp(y(16)*params(5));
  g1(44,23)=(-exp(y(23)));
  g1(44,24)=exp(y(24))-exp(y(24))*(1-params(10));
  g1(44,26)=exp(y(26));
  g1(44,31)=T840;
  g1(45,25)=exp(y(25));
  g1(45,28)=(-(T703*T708));
  g1(46,27)=(-(T36*exp(y(27))));
  g1(46,29)=(-(T36*(1+exp(y(27))-params(10))));
  g1(47,25)=(-((T21*T617*params(1)-T617*T21*params(1))/(T21*T21)));
  g1(47,26)=(-((T21*params(1)*exp(y(26))*T616-T21*params(1)*exp(y(26))*T616)/(T21*T21)));
  g1(47,29)=T36;
  g1(48,1)=(-(T36*exp(y(1))*exp(y(16))));
  g1(48,16)=T400;
  g1(48,18)=1-T36*(1-exp(y(16)));
  g1(48,29)=T741;
  g1(49,18)=(-params(7));
  g1(49,19)=1-T36*(1-params(7));
  g1(49,29)=(-(y(19)*T36*(1-params(7))));
  g1(50,3)=y(19)*T111*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(50,19)=T111*params(4)*exp(y(3)*(params(4)-1));
  g1(51,1)=(-(exp(y(1))*T36));
  g1(51,16)=T36*params(6)*params(5)*(params(5)-1)*exp(y(16)*(params(5)-1));
  g1(51,18)=T36;
  g1(51,29)=T726;
  g1(52,1)=(-(T36*exp(y(1))*exp(y(14)-y(31))));
  g1(52,14)=T353;
  g1(52,21)=1-T36*(1-exp(y(14)-y(31)));
  g1(52,29)=T755;
  g1(52,31)=T847;
  g1(53,21)=(-params(7));
  g1(53,22)=1-T36*(1-params(7));
  g1(53,29)=(-(y(22)*T36*(1-params(7))));
  g1(54,4)=y(22)*T142*params(4)*(params(4)-1)*exp(y(4)*(params(4)-1));
  g1(54,22)=T142*params(4)*exp(y(4)*(params(4)-1));
  g1(55,1)=(-(exp(y(1))*T36*exp((-y(31)))));
  g1(55,14)=T36*params(6)*params(5)*(params(5)-1)*exp((y(14)-y(31))*(params(5)-1));
  g1(55,21)=T36*exp((-y(31)));
  g1(55,29)=T719;
  g1(55,31)=T857;
  g1(56,9)=exp(y(9))-exp(y(9))*(1-exp(y(16)));
  g1(56,12)=(-(params(7)*exp(y(12))));
  g1(56,16)=(-(exp(y(9))*(-exp(y(16)))));
  g1(57,8)=exp(y(8))-exp(y(8))*(1-exp((-y(31)))*exp(y(15)));
  g1(57,11)=(-(exp(y(11))*params(7)));
  g1(57,15)=(-(exp(y(8))*(-(exp((-y(31)))*exp(y(15))))));
  g1(57,31)=(-(exp(y(8))*(-(exp(y(15))*(-exp((-y(31))))))));
  g1(58,10)=exp(y(10))-exp(y(10))*(1-exp((-y(31)))*exp(y(14)));
  g1(58,13)=(-(params(7)*exp(y(13))));
  g1(58,14)=(-(exp(y(10))*(-(exp((-y(31)))*exp(y(14))))));
  g1(58,31)=(-(exp(y(10))*(-(exp(y(14))*(-exp((-y(31))))))));
  g1(59,3)=(-(T111*params(4)*exp(params(4)*y(3))));
  g1(59,12)=exp(y(12))-(1-params(7))*exp(y(12));
  g1(60,2)=(-(T91*params(4)*exp(y(2)*params(4))));
  g1(60,11)=exp(y(11))-exp(y(11))*(1-params(7));
  g1(61,4)=(-(T142*params(4)*exp(y(4)*params(4))));
  g1(61,13)=exp(y(13))-(1-params(7))*exp(y(13));
  g1(62,7)=exp(y(7));
  g1(62,9)=(-(exp(y(16))*exp(y(9))));
  g1(62,16)=(-(exp(y(16))*exp(y(9))));
  g1(63,5)=exp(y(5));
  g1(63,8)=(-(exp(y(8))*exp((-y(31)))*exp(y(15))));
  g1(63,15)=(-(exp(y(8))*exp((-y(31)))*exp(y(15))));
  g1(63,31)=(-(exp(y(8))*exp(y(15))*(-exp((-y(31))))));
  g1(64,6)=exp(y(6));
  g1(64,10)=(-(exp(y(10))*exp((-y(31)))*exp(y(14))));
  g1(64,14)=(-(exp(y(10))*exp((-y(31)))*exp(y(14))));
  g1(64,31)=(-(exp(y(10))*exp(y(14))*(-exp((-y(31))))));
  g1(65,5)=(-exp(y(5)));
  g1(65,6)=(-exp(y(6)));
  g1(65,7)=(-exp(y(7)));
  g1(65,20)=exp(y(20));
  g1(66,31)=1;
  g1(67,30)=1-(params(16)+params(17));
  g1(68,15)=(-exp(y(15)));
  g1(68,38)=exp(y(38));
  g1(69,32)=1;
  g1(70,33)=1;
  g1(71,34)=1;
  g1(72,35)=1;
  g1(73,36)=1;
  g1(74,37)=1;
  g1(75,67)=(-1);
  g1(75,75)=1;
  g1(76,30)=(-1);
  g1(76,76)=1;
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],76,5776);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],76,438976);
end
end
end
end
